//
//  MTKParser.h
//  Dash Monitors
//
//  Created by Mike Piatek-Jimenez on 4/26/05.
//  Copyright 2005 Gaucho Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MTKParser : NSObject {
	NSTask				*mtkTask;
	NSPipe				*mtkPipe;
	NSMutableString		*buffer;
	bool				suspended;
	
	NSString			*mtkPath;
	float				interval;
	NSString			*plugins;
	NSString			*pluginDirectory;
	
	NSMutableArray		*columnNames;
	NSMutableDictionary *dataValues;
}

#pragma mark Configuration
- (void) setMTKPath:(NSString *)execPath;
- (void) setInterval:(float)seconds;
- (void) setPlugins:(NSString *)pluginString;
- (void) setPluginDirectory:(NSString *)pluginDir;

#pragma mark Control
- (void) launch;
- (void) suspend;
- (bool) suspended;
- (void) resume;
- (void) kill;

#pragma mark Information Retrieval
- (id) objectForKey:(NSString *)key;
- (int) intForKey:(NSString *)key;
- (float) floatForKey:(NSString *)key;

#pragma mark Utility Methods
- (void) readFromMTKPipe:(NSNotification*)aNotification;
- (void) parseBuffer;

@end
